package cn.lili.modules.message.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.message.fallback.WechatMessageFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * @author: ftyy
 * @date: 2022-01-14 9:42
 * @description: 微信Client
 */
@FeignClient(
        name = ServiceConstant.SYSTEM_SERVICE,
        contextId = "wechat-message",
        fallback = WechatMessageFallback.class)
public interface WechatMessageClient {

    /**
     * 初始化微信消息模版
     */
    @GetMapping("/feign/wechat-message/init")
    void init();

    /**
     * 微信发送消息
     * @param sn
     */
    @GetMapping("/feign/wechat-message/send/{sn}")
    void sendWechatMessage(@PathVariable String sn);


    @GetMapping("/feign/wechat-message/mq/send/{sn}")
    void wechatMpMessage(@PathVariable String sn);
}
