package cn.lili.modules.order.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.order.order.client.OrderClient;
import cn.lili.modules.order.order.entity.dos.Order;
import cn.lili.modules.order.order.entity.dto.OrderSearchParams;
import cn.lili.modules.order.order.entity.dto.PaymentLogSearchParams;
import cn.lili.modules.order.order.entity.vo.OrderDetailVO;
import cn.lili.modules.order.order.entity.vo.PaymentLog;
import cn.lili.modules.store.entity.dos.Store;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:21
 * @description: 订单服务 Fallback
 */
@Component
public class OrderFallback implements OrderClient {

    @Override
    public Order getBySn(String sn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void payOrder(String sn, String paymentMethod, String receivableNo,String payOrderNo) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void systemCancel(String orderSn, String reason) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Double getPaymentTotal(String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public OrderDetailVO queryDetail(String sn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Order> getByTradeSn(String sn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Order> queryListByParams(OrderSearchParams orderSearchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Order> queryListByPromotion(
            String orderPromotionType, String payStatus, String parentOrderSn, String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public long queryCountByPromotion(
            String orderPromotionType, String payStatus, String parentOrderSn, String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public boolean checkFictitiousOrder(String pintuanId, Integer requiredNum, Boolean fictitious) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void save(Order order) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void afterOrderConfirm(String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 系统定时完成订单
     *
     * @param orderSn 订单编号
     */
    @Override
    public void systemComplete(String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 自动成团订单处理
     *
     * @param pintuanId     拼团活动id
     * @param parentOrderSn 拼团订单sn
     */
    @Override
    public void agglomeratePintuanOrder(String pintuanId, String parentOrderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void update(Order order) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Order getOne(Order order) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<Order> getOrderListByTrade(String sn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Page<PaymentLog> queryPaymentLogs(PaymentLogSearchParams paymentLogSearchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<PaymentLog> queryPaymentLogsList(PaymentLogSearchParams paymentLogSearchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void editPaymentLogsList(List<PaymentLog> paymentLogList) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreName(Store store) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void afterSaleCallBack(Boolean success, String orderSn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateMchInfo(Order order) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Boolean updateSelective(Order order) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
