package cn.lili.modules.order.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.order.order.client.OrderItemClient;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.order.order.entity.dto.OrderSearchParams;
import cn.lili.modules.order.order.entity.enums.CommentStatusEnum;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:24
 * @description: 子订单Fallback
 */
@Component
public class OrderItemFallback implements OrderItemClient {

    @Override
    public OrderItem getBySn(String sn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public OrderItem getByOrderSnAndSkuId(String orderSn, String skuId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<OrderItem> getByOrderSn(String sn) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateCommentStatus(String sn, CommentStatusEnum finished) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateById(OrderItem orderItem) {
        throw new ServiceException(ResultCode.ERROR);
    }


    /**
     * 获取等待操作订单子项目
     *
     * @param searchParams 查询条件
     * @return 订单子项列表
     */
    @Override
    public List<OrderItem> waitOperationOrderItem(OrderSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 修改订单售后状态
     *
     * @param orderItemIdList 获取订单货物ID
     * @return 是否操作成功
     */
    @Override
    public boolean updateAfterSale(List<String> orderItemIdList) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 修改订单投诉状态
     *
     * @param orderItemIdList 获取订单货物ID
     * @return 是否操作成功
     */
    @Override
    public boolean updateComplainStatus(List<String> orderItemIdList) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void update(OrderItem orderItem) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void saveBatch(List<OrderItem> orderItems) {
        throw new ServiceException(ResultCode.ERROR);
    }

}
