package cn.lili.modules.order.order.client;


import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.AfterSaleFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


/**
 * 售后client
 * @author ftyy
 * @since 2023/04/23
 **/
@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "after-sale",
        fallback = AfterSaleFallback.class)
public interface AfterSaleClient {
    /**
     * 修改售后中店铺名称
     * @param store  店铺信息
     */
    @PutMapping("/feign/after-sale/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
