package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.OrderComplaintFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * 订单投诉client
 * @author ftyy
 * @since 2023/04/23
 **/
@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "order-complaint",
        fallback = OrderComplaintFallback.class)
public interface OrderComplaintClient {
    /**
     * 修改订单投诉中店铺名称
     * @param store  店铺信息
     */
    @PutMapping("/feign/order-complaint/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
