package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.OrderComplaintStatisticsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author paulG
 * @since 2022/6/28
 **/
@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "order-complaint-statistics",
        fallback = OrderComplaintStatisticsFallback.class)
public interface OrderComplaintStatisticsClient {

    /**
     * 待处理投诉数量
     *
     * @param storeId 店铺id
     * @return 待处理投诉数量
     */
    @GetMapping("/feign/order/complain/statistics")
    long waitComplainNum(@RequestParam String storeId);

}
