package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.OrderItemFallback;
import cn.lili.modules.order.order.entity.dos.OrderItem;
import cn.lili.modules.order.order.entity.dto.OrderSearchParams;
import cn.lili.modules.order.order.entity.enums.CommentStatusEnum;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 子订单 client
 *
 * @author Chopper
 * @version v1.0 2021-11-08 09:52
 */
@FeignClient(
    name = ServiceConstant.ORDER_SERVICE,
    contextId = "order-item",
    fallback = OrderItemFallback.class)
public interface OrderItemClient {

  /**
   * 子订单查询
   *
   * @param sn 子订单编号
   * @return 子订单
   */
  @GetMapping("/feign/orderitem/query/{sn}")
  OrderItem getBySn(@PathVariable String sn);

  /**
   * 子订单查询
   *
   * @param orderSn 订单编号
   * @param skuId skuid
   * @return 子订单
   */
  @GetMapping("/feign/orderitem/query/order-sn-and-sku-id")
  OrderItem getByOrderSnAndSkuId(
      @RequestParam("orderSn") String orderSn, @RequestParam("skuId") String skuId);

  /**
   * 根据订单号查询子订单
   *
   * @param sn 订单编号
   * @return 子订单集合
   */
  @GetMapping("/feign/orderitem/query-by-order/{sn}")
  List<OrderItem> getByOrderSn(@PathVariable String sn);

  /**
   * 修改评论状态
   *
   * @param sn 订单编号
   * @param finished 评论状态
   */
  @GetMapping("/feign/orderitem/update/status")
  void updateCommentStatus(@RequestParam String sn, @RequestParam CommentStatusEnum finished);

  /**
   * 根据id修改模型
   *
   * @param orderItem 自订单
   */
  @PutMapping("/feign/orderitem/updateById")
  void updateById(@RequestBody OrderItem orderItem);

  @PostMapping("/feign/orderitem/save-batch")
  void saveBatch(@RequestBody List<OrderItem> orderItems);

  /**
   * 获取等待操作订单子项目
   *
   * @param searchParams 查询条件
   * @return 订单子项列表
   */
  @PostMapping("/feign/order-item/wait-operation")
  List<OrderItem> waitOperationOrderItem(@RequestBody OrderSearchParams searchParams);

  /**
   * 修改订单售后状态
   *
   * @param orderItemIdList 获取订单货物ID
   * @return 是否操作成功
   */
  @PutMapping("/feign/order-item/update/after-sale")
  boolean updateAfterSale(@RequestBody List<String> orderItemIdList);

  /**
   * 修改订单投诉状态
   *
   * @param orderItemIdList 获取订单货物ID
   * @return 是否操作成功
   */
  @PutMapping("/feign/order-item/update/complain")
  boolean updateComplainStatus(@RequestBody List<String> orderItemIdList);


  @PutMapping("/feign/orderitem/update")
  void update(@RequestBody OrderItem orderItem);
}
