package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.OrderStatisticsFallback;
import cn.lili.modules.order.order.entity.dto.OrderStatisticsSearchParams;
import cn.lili.modules.order.order.entity.vo.OrderSimpleVO;
import cn.lili.modules.statistics.entity.dto.OrderPromotionStatisticsQueryParam;
import cn.lili.modules.statistics.entity.dto.StatisticsQueryParam;
import cn.lili.modules.statistics.entity.vo.OrderStatisticsDataVO;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author paulG
 * @since 2022/6/28
 **/
@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "order-statistics",
        fallback = OrderStatisticsFallback.class)
public interface OrderStatisticsClient {

    /**
     * 获取订单总数量
     *
     * @param orderStatus 订单状态
     * @return 订单总数量
     */
    @GetMapping("/feign/order/statistics/orderNum")
    long orderNum(@RequestParam String orderStatus, @RequestParam String storeId);

    /**
     * 图表统计
     *
     * @param statisticsQueryParam 统计查询参数
     * @return 订单总数量
     */
    @PostMapping("/feign/order/statistics/statisticsChart")
    List<OrderStatisticsDataVO> statisticsChart(@RequestBody StatisticsQueryParam statisticsQueryParam);

    /**
     * 获取统计的订单
     *
     * @param statisticsQueryParam
     * @return
     */
    @PostMapping("/feign/order/statistics/getStatistics")
    Page<OrderSimpleVO> getStatistics(@RequestBody StatisticsQueryParam statisticsQueryParam);


    @PostMapping("/feign/order/statistics/getMap")
    Map<String, Object> getMap(@RequestBody OrderStatisticsSearchParams searchParams);


    /**
     * 获取活动的统计的订单
     *
     * @param statisticsQueryParam
     * @return
     */
    @PostMapping("/feign/order/statistics/getOrderPromotionStatistics")
    Page<OrderSimpleVO> getOrderPromotionStatistics(@RequestBody OrderPromotionStatisticsQueryParam statisticsQueryParam);
}
