package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.ReceiptFallback;
import cn.lili.modules.order.order.entity.dos.Receipt;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:59
 * @description: 发票Client
 */
@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "receipt",
        fallback = ReceiptFallback.class)
public interface ReceiptClient {

    /**
     * 根据订单编号获取发票信息
     *
     * @param orderSn 订单编号
     * @return 发票
     */
    @GetMapping("/feign/order/receipt/getByOrderSn/{orderSn}")
    Receipt getByOrderSn(@PathVariable String orderSn);

    /**
     * 获取发票详情
     *
     * @param id 发票id
     * @return 发票详情
     */
    @GetMapping("/feign/order/receipt/getDetail/{id}")
    Receipt getDetail(@PathVariable String id);

    /**
     * 保存发票
     *
     * @param receipt 发票信息
     * @return 是否保存成功
     */
    @PostMapping("/feign/order/receipt/saveReceipt")
    Receipt saveReceipt(@RequestBody Receipt receipt);

    /**
     * 开具发票
     *
     * @param receiptId 发票id
     * @return
     */
    @GetMapping("/feign/order/receipt/invoicing/{receiptId}")
    Receipt invoicing(@PathVariable String receiptId);

    @PostMapping("/feign/order/receipt")
    boolean saveBatch(@RequestBody List<Receipt> receipts);

    /**
     * 修改发票中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/order/receipt/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
