package cn.lili.modules.order.order.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.AfterSaleFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @Author yuquanfeng
 * @Date 2023/9/6
 * @Description
 **/
@FeignClient(
        name = ServiceConstant.ORDER_SERVICE,
        contextId = "order-task",
        fallback = AfterSaleFallback.class)
public interface TaskClient {

    @GetMapping("/feign/aftersale/returnGoodsDeliveryTimeout")
    Boolean returnGoodsDeliveryTimeout();

    @GetMapping("/feign/order/autoCancel")
    Boolean autoCancel();


    @GetMapping("/feign/order/autoReceive")
    Boolean autoReceive();
}
