package cn.lili.modules.order.order.entity.dto;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.lili.common.utils.StringUtils;
import cn.lili.common.vo.PageVO;
import cn.lili.modules.order.order.entity.enums.PayStatusEnum;
import cn.lili.modules.order.order.entity.vo.PaymentLog;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

@Data
public class PaymentLogSearchParams extends PageVO {

    @ApiModelProperty(value = "支付方式")
    private String paymentMethod;

    /**
     * @see PayStatusEnum
     */
    @ApiModelProperty(value = "付款状态")
    private String payStatus;

    @ApiModelProperty("订单编号")
    private String sn;

    @ApiModelProperty(value = "支付时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date paymentTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;

    private List<String> storeId;

    private String storeName;

    private String subMchid;

    public <T> QueryWrapper<T> queryWrapper() {

        QueryWrapper<T> wrapper = new QueryWrapper<>();

        wrapper.eq(CharSequenceUtil.isNotEmpty(payStatus), "pay_status", payStatus);
        if (CharSequenceUtil.isNotEmpty(sn)) {
            wrapper.like("sn", sn);
        }
        if(storeId != null && storeId.size() > 0) {
            wrapper.in("store_id",storeId);
        }
        if(storeId != null && storeId.size() == 0) {
            wrapper.in("store_id",0);
        }
        if(startDate != null){
            wrapper.ge("payment_time",startDate);
        }
        if(endDate != null){
            wrapper.le("payment_time",endDate);
        }
        if(StringUtils.isNotEmpty(storeName)) {
            wrapper.eq("store_name", storeName);
        }
        if(StringUtils.isNotEmpty(subMchid)) {
            wrapper.eq("sub_mchid", subMchid);
        }
        //按支付方式
        wrapper.eq(CharSequenceUtil.isNotEmpty(paymentMethod), "payment_method", paymentMethod);
        return wrapper;
    }
}
