package cn.lili.modules.order.trade.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.order.fallback.OrderLogFallback;
import cn.lili.modules.order.trade.entity.dos.OrderLog;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:33
 * @description: 订单日志Client
 */
@FeignClient(
    name = ServiceConstant.ORDER_SERVICE,
    contextId = "order-log",
    fallback = OrderLogFallback.class)
public interface OrderLogClient {
  /**
   * 根据订单编号获取订单日志列表
   *
   * @param orderSn 订单编号
   * @return 订单日志列表
   */
  @GetMapping("/feign/order/log/{orderSn}")
  List<OrderLog> getOrderLog(@PathVariable String orderSn);

  @PostMapping("/feign/order/log")
  void saveBatch(@RequestBody List<OrderLog> orderLogs);
}
