package cn.lili.modules.order.trade.entity.dto;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 预存款充值记录查询条件
 *
 * @author pikachu
 * @since 2020-02-25 14:10:16
 */
@Data
@ApiModel(value = "预存款充值记录查询条件")
@AllArgsConstructor
@NoArgsConstructor
public class RechargeQueryParams implements Serializable {


    private static final long serialVersionUID = 318396158590640917L;

    /**
     * 充值订单编号
     */
    @ApiModelProperty(value = "充值订单编号")
    private String rechargeSn;

    /**
     * 会员ID
     */
    @ApiModelProperty(value = "会员Id")
    private String memberId;
    /**
     * 会员名称
     */
    @ApiModelProperty(value = "会员名称")
    private String memberName;
    /**
     * 充值时间
     */
    @ApiModelProperty(value = "充值开始时间")
    private String startDate;

    /**
     * 充值时间
     */
    @ApiModelProperty(value = "充值结束时间")
    private String endDate;

    @ApiModelProperty(value = "支付状态")
    private String payStatus;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Date leCreateTime;

    public <T> QueryWrapper<T> queryWrapper() {
        QueryWrapper<T> queryWrapper = new QueryWrapper<>();
        //会员名称
        queryWrapper.like(!CharSequenceUtil.isEmpty(this.getMemberName()), "member_name", this.getMemberName());
        //充值订单号
        queryWrapper.eq(!CharSequenceUtil.isEmpty(this.getRechargeSn()), "recharge_sn", this.getRechargeSn());
        //会员id
        queryWrapper.eq(!CharSequenceUtil.isEmpty(this.getMemberId()), "member_id", this.getMemberId());
        //支付状态
        queryWrapper.eq(!CharSequenceUtil.isEmpty(payStatus), "pay_status", payStatus);
        //小于订单创建时间
        queryWrapper.le(leCreateTime != null, "create_time", leCreateTime);
        //支付时间 开始时间和结束时间
        if (!CharSequenceUtil.isEmpty(this.getStartDate()) && !CharSequenceUtil.isEmpty(this.getEndDate())) {
            Date start = DateUtil.parse(this.getStartDate());
            Date end = DateUtil.parse(this.getEndDate());
            queryWrapper.between("pay_time", start, end);
        }
        queryWrapper.orderByDesc("create_time");
        return queryWrapper;
    }

}