package cn.lili.modules.order.trade.entity.enums;

/**
 * 售后类型
 *
 * @author Chopper
 * @since 2020/8/20 15:39
 */

public enum AfterSaleTypeEnum {
    /**
     * 售后服务类型枚举
     */
    RETURN_MONEY("退款"), RETURN_GOODS("退货退款");

    private String description;

    AfterSaleTypeEnum(String description) {
        this.description = description;
    }

    public String description() {
        return description;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static String getDescByName(String name) {
        for (AfterSaleTypeEnum exampleEnum : AfterSaleTypeEnum.values()) {
            if (exampleEnum.name().equals(name)) {
                return exampleEnum.getDescription();
            }
        }
        return "";
    }

}
