package cn.lili.modules.payment.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.store.entity.params.BillParams;
import cn.lili.modules.store.fallback.BillFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 结算单 client
 *
 * @author Chopper
 * @version v1.0 2021-11-08 09:52
 */
@FeignClient(
        name = ServiceConstant.PAYMENT_SERVICE,
        contextId = "bill",
        fallback = BillFallback.class)
public interface BillClient {


    /**
     * 生成结算单
     *
     * @param billParams
     */
    @PostMapping("/feign/store/bill/create")
    void createBill(@RequestBody BillParams billParams);

    /**
     * 立即结算
     * 用于关闭商家，立即结算使用
     *
     * @param billParams
     */
    @PostMapping("/feign/store/bill/immediately")
    void immediatelyBill(@RequestBody BillParams billParams);

    /**
     * 修改结算单中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/store/bill/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
