package cn.lili.modules.payment.entity.dos;

import cn.lili.common.enums.ClientTypeEnum;
import cn.lili.modules.payment.dto.PayParam;
import cn.lili.modules.payment.entity.enums.PaymentMethodEnum;
import cn.lili.mybatis.BaseIdEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 支付唤起日志
 *
 * @author Chopper
 * @since 2021/1/28 09:21
 */
@Data
@TableName("li_payment_wakeup")
@Builder
@ApiModel(value = "支付唤起日志")
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class PaymentWakeup extends BaseIdEntity {


    private static final long serialVersionUID = 647253814608116958L;


    @NotNull
    @ApiModelProperty(value = "交易类型", allowableValues = "TRADE,ORDER,RECHARGE")
    private String orderType;
    @ApiModelProperty(value = "订单编号")
    private String orderSn;

    @ApiModelProperty(value = "支付名称")
    private String paymentName;

    @ApiModelProperty(value = "支付插件")
    private String paymentMethod;
    @ApiModelProperty(value = "金额")
    private Double price;
    @ApiModelProperty(value = "已校验回查")
    private Boolean isCheck = false;

    @ApiModelProperty(value = "是否重复支付")
    private Boolean isRepeat = false;

    @ApiModelProperty(value = "已付款")
    private Boolean isPay = false;


    @ApiModelProperty(value = "已退款")
    private Boolean isRefund = false;


    @ApiModelProperty(value = "支付发起交易号")
    private String payOrderNo;


    @ApiModelProperty(value = "第三方付款流水号")
    private String paymentReceivableNo;

    @ApiModelProperty(value = "支付请求参数")
    private String paymentRequestSource;


    @ApiModelProperty(value = "支付响应")
    private String paymentResponseSource;


    @ApiModelProperty(value = "退款请求流水")
    private String outOrderNo;


    @ApiModelProperty(value = "第三方退款流水号")
    private String refundReceivableNo;

    @ApiModelProperty(value = "退款失败错误消息")
    private String refundMessage;


    /**
     * @see ClientTypeEnum
     */
    @ApiModelProperty(value = "订单来源")
    private String clientType;


    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "支付过期时间", hidden = true)
    private Date timeoutExpress;
    @CreatedDate
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Date createTime;

    @ApiModelProperty(value = "合单支付单号", hidden = true)
    private String combineOutTradeNo;
    @ApiModelProperty
    private String memberId;
    public PaymentWakeup(PayParam payParam, PaymentMethodEnum paymentMethodEnum) {
        this.orderType = payParam.getOrderType();

        this.orderSn = payParam.getSn();
        this.clientType = payParam.getClientType();


        this.paymentName = paymentMethodEnum.paymentName();
        this.paymentMethod = paymentMethodEnum.getPlugin();

    }
}