package cn.lili.modules.payment.entity.dos;

import cn.hutool.json.JSONUtil;
import cn.lili.modules.wechat.entity.dto.applyments.EcommerceDTO;
import cn.lili.modules.wechat.entity.enums.ApplymentStatusEnum;
import cn.lili.mybatis.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 微信服务商进件
 *
 * @author Bulbasaur
 * https://pay.weixin.qq.com/wiki/doc/apiv3_partner/apis/chapter7_1_1.shtml
 */
@Data
@TableName("li_wechat_applyment")
@ApiModel(value = "微信服务商进件")
@NoArgsConstructor
public class WechatApplyment extends BaseEntity {

    @ApiModelProperty(value = "业务申请编号")
    String outRequestNo;
    @ApiModelProperty(value = "主体类型")
    String organizationType;
    @ApiModelProperty(value = "是否金融机构")
    Boolean financeInstitution;
    @ApiModelProperty(value = "营业执照/登记证书信息")
    String businessLicenseInfo;
    @ApiModelProperty(value = "金融机构许可证信息")
    String financeInstitutionInfo;
    @ApiModelProperty(value = "证件持有人类型")
    String idHolderType;
    @ApiModelProperty(value = "经营者/法人证件类型")
    String idDocType;
    @ApiModelProperty(value = "法定代表人说明函")
    String authorizeLetterCopy;
    @ApiModelProperty(value = "经营者/法人身份证信息")
    String idCardInfo;
    @ApiModelProperty(value = "经营者/法人其他类型证件信息")
    String idDocInfo;
    @ApiModelProperty(value = "经营者/法人是否为受益人")
    Boolean owner;
    @ApiModelProperty(value = "最终受益人信息列表")
    String uboInfoList;
    @ApiModelProperty(value = "结算账户信息")
    String accountInfo;
    @ApiModelProperty(value = "超级管理员信息")
    String contactInfo;
    @ApiModelProperty(value = "店铺信息")
    String salesSceneInfo;
    @ApiModelProperty(value = "结算规则")
    String settlementInfo;
    @ApiModelProperty(value = "商户简称")
    String merchantShortname;
    @ApiModelProperty(value = "特殊资质")
    String qualifications;
    @ApiModelProperty(value = "补充材料")
    String businessAdditionPics;
    @ApiModelProperty(value = "补充说明")
    String businessAdditionDesc;

    /**
     * @see ApplymentStatusEnum
     */
    @ApiModelProperty(value = "状态")
    String status;
    @ApiModelProperty(value = "申请状态描述")
    String applymentStateMsg;
    @ApiModelProperty(value = "错误信息")
    String errorMessage;
    /**
     * 特约商户号，当申请单状态为APPLYMENT_STATE_FINISHED时才返回。
     */
    @ApiModelProperty(value = "特约商户号")
    String subMchid;

    /**
     * 微信支付分配的申请单号。
     */
    @ApiModelProperty(value = "微信支付申请单号")
    String applymentId;

    @ApiModelProperty(value = "签约链接")
    String signUrl;

    public WechatApplyment(EcommerceDTO ecommerceDTO) {

        this.outRequestNo = ecommerceDTO.getOut_request_no();
        this.organizationType = ecommerceDTO.getOrganization_type();
        this.financeInstitution = ecommerceDTO.getFinance_institution();
        this.businessLicenseInfo = JSONUtil.toJsonStr(ecommerceDTO.getBusiness_license_info());
        this.financeInstitutionInfo = JSONUtil.toJsonStr(ecommerceDTO.getFinance_institution_info());
        this.idHolderType = ecommerceDTO.getId_holder_type();
        this.idDocType = ecommerceDTO.getId_doc_type();
        this.authorizeLetterCopy = ecommerceDTO.getAuthorize_letter_copy();
        this.idCardInfo = JSONUtil.toJsonStr(ecommerceDTO.getId_card_info());
        this.idDocInfo = JSONUtil.toJsonStr(ecommerceDTO.getId_doc_info());
        this.owner = ecommerceDTO.getOwner();
        this.uboInfoList = JSONUtil.toJsonStr(ecommerceDTO.getUbo_info_list());
        this.accountInfo = JSONUtil.toJsonStr(ecommerceDTO.getAccount_info());
        this.contactInfo = JSONUtil.toJsonStr(ecommerceDTO.getContact_info());
        this.salesSceneInfo = JSONUtil.toJsonStr(ecommerceDTO.getSales_scene_info());
        this.settlementInfo = JSONUtil.toJsonStr(ecommerceDTO.getSettlement_info());
        this.merchantShortname = ecommerceDTO.getMerchant_shortname();
        this.qualifications = JSONUtil.toJsonStr(ecommerceDTO.getQualifications());
        this.businessAdditionPics = ecommerceDTO.getBusiness_addition_pics();
        this.businessAdditionDesc = ecommerceDTO.getBusiness_addition_desc();

    }
}
