package cn.lili.modules.payment.entity.enums;

/**
 * 退款状态枚举
 *
 * @author Chopper
 * @since 2020/11/17 7:28 下午
 */
public enum RefundStatusEnum {

    /**
     * 退款状态
     */
    UNREFUND("待退款"),
    REFUND("已退款"),
    ACCOUNT("已对账"),
    ACCOUNT_ERROR("对账失败");

    private final String description;

    RefundStatusEnum(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }


}
