package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.entity.dos.KanjiaActivity;
import cn.lili.modules.promotion.entity.dto.search.KanjiaActivitySearchParams;
import cn.lili.modules.promotion.fallback.KanjiaActivityFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author: ftyy
 * @date: 2022-01-13 18:47
 * @description: 描述
 */
@FeignClient(
        name = ServiceConstant.PROMOTION_SERVICE,
        contextId = "kanjia-activity",
        fallback = KanjiaActivityFallback.class)
public interface KanjiaActivityClient {

    /**
     * 结束砍价活动
     *
     * @param kanjiaId 砍价活动id
     * @return 是否更新成功
     */
    @GetMapping("/feign/promotion/kanjia-activity/end")
    boolean endKanjiaActivity(@RequestParam String kanjiaId);

    @GetMapping("/feign/promotion/kanjia-activity/getById")
    KanjiaActivity getById(@RequestParam String promotionId);

    /**
     * 获取砍价活动
     *
     * @param kanJiaActivitySearchParams 砍价活动搜索参数
     * @return 砍价活动
     */
    @PostMapping("/feign/promotion/kanjia-activity/getKanjiaActivity")
    KanjiaActivity getKanjiaActivity(@RequestBody KanjiaActivitySearchParams kanJiaActivitySearchParams);
}
