package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.entity.dos.KanjiaActivityGoods;
import cn.lili.modules.promotion.entity.dto.KanjiaActivityGoodsDTO;
import cn.lili.modules.promotion.entity.dto.KanjiaActivityGoodsOperationDTO;
import cn.lili.modules.promotion.entity.vos.kanjia.KanjiaActivityGoodsVO;
import cn.lili.modules.promotion.fallback.KanjiaActivityGoodsFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: ftyy
 * @date: 2022-01-13 18:55
 * @description: 砍价Client
 */
@FeignClient(
        name = ServiceConstant.PROMOTION_SERVICE,
        contextId = "kanjia-activity-goods",
        fallback = KanjiaActivityGoodsFallback.class)
public interface KanjiaActivityGoodsClient {

    /**
     * 添加砍价活动商品
     *
     * @param kanJiaActivityGoodsDTOS 砍价商品
     * @return 是否添加成功
     */
    @PostMapping("/feign/promotion/kanjia-activity-goods/add")
    Boolean add(@RequestBody KanjiaActivityGoodsOperationDTO kanJiaActivityGoodsDTOS);

    /**
     * 查询砍价活动商品
     *
     * @param goodsId 砍价活动商品id
     * @return 砍价活动商品信息
     */
    @GetMapping("/feign/promotion/kanjia-activity-goods/getKanjiaGoodsDetail/{goodsId}")
    KanjiaActivityGoodsDTO getKanjiaGoodsDetail(@PathVariable String goodsId);

    /**
     * 根据SkuId获取正在进行中的砍价商品
     *
     * @param skuId 商品规格Id
     * @return 砍价商品
     */
    @GetMapping("/feign/promotion/kanjia-activity-goods/getKanjiaGoodsBySkuId/{skuId}")
    KanjiaActivityGoods getKanjiaGoodsBySkuId(@PathVariable String skuId);

    /**
     * 查询砍价活动商品VO
     *
     * @param id 砍价活动商品ID
     * @return 砍价活动商品
     */
    @GetMapping("/feign/promotion/kanjia-activity-goods/getKanJiaGoodsVO/{id}")
    KanjiaActivityGoodsVO getKanJiaGoodsVO(@PathVariable String id);

    /**
     * 修改看见商品信息
     *
     * @param kanjiaActivityGoodsDTO 砍价商品信息
     * @return 是否修改成功
     */
    @PutMapping("/feign/promotion/kanjia-activity-goods/updateKanjiaActivityGoods")
    boolean updateKanjiaActivityGoods(@RequestBody KanjiaActivityGoodsDTO kanjiaActivityGoodsDTO);

    @PutMapping("/feign/promotion/kanjia-activity-goods/updateById")
    void updateById(@RequestBody KanjiaActivityGoodsDTO kanjiaActivityGoodsDTO);

    /**
     * 修改砍价活动商品中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/promotion/kanjia-activity-goods/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
