package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.entity.dos.PointsGoods;
import cn.lili.modules.promotion.entity.vos.PointsGoodsVO;
import cn.lili.modules.promotion.fallback.PointsGoodsFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 19:26
 * @description: 积分商品Client
 */
@FeignClient(
        name = ServiceConstant.PROMOTION_SERVICE,
        contextId = "points-goods",
        fallback = PointsGoodsFallback.class)
public interface PointsGoodsClient {

    /**
     * 批量保存库存商品
     *
     * @param promotionsList 积分商品列表
     * @return 是否保存成功
     */
    @PostMapping("/feign/promotion/points-goods/savePointsGoodsBatch")
    boolean savePointsGoodsBatch(@RequestBody List<PointsGoods> promotionsList);

    /**
     * 根据ID获取积分详情
     *
     * @param id 积分商品id
     * @return 积分详情
     */
    @GetMapping("/feign/promotion/points-goods/getPointsGoodsDetail/{id}")
    PointsGoodsVO getPointsGoodsDetail(@PathVariable String id);

    /**
     * 根据ID获取积分详情
     *
     * @param skuId 商品SkuId
     * @return 积分详情
     */
    @GetMapping("/feign/promotion/points-goods/getPointsGoodsDetailBySkuId/{skuId}")
    PointsGoodsVO getPointsGoodsDetailBySkuId(@PathVariable String skuId);

    @PutMapping("/feign/promotion/points-goods/updateById")
    void updateById(@RequestBody PointsGoodsVO pointsGoodsVO);

    /**
     * 修改积分商品中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/promotion/points-goods/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
