package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dto.GoodsSkuDTO;
import cn.lili.modules.promotion.entity.dos.Coupon;
import cn.lili.modules.promotion.entity.dos.MemberCoupon;
import cn.lili.modules.promotion.entity.dos.PromotionGoods;
import cn.lili.modules.promotion.entity.dto.search.KanjiaActivitySearchParams;
import cn.lili.modules.promotion.entity.dto.search.MemberCouponSearchParams;
import cn.lili.modules.promotion.entity.dto.search.PromotionGoodsSearchParams;
import cn.lili.modules.promotion.entity.vos.PintuanVO;
import cn.lili.modules.promotion.entity.vos.PointsGoodsVO;
import cn.lili.modules.promotion.entity.vos.kanjia.KanjiaActivityVO;
import cn.lili.modules.promotion.fallback.PromotionsFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 促销Client
 * @author paulG
 * @since 2021/12/28
 **/
@FeignClient(name = ServiceConstant.PROMOTION_SERVICE, contextId = "promotions",fallback = PromotionsFallback.class)
public interface PromotionsClient {

    /**
     * 根据当前会员有效的优惠券
     *
     * @return 当前促销活动集合
     */
    @PostMapping("/feign/promotion/member/coupon/list")
    List<MemberCoupon> getMemberCoupons(@RequestBody MemberCouponSearchParams param);

    /**
     * 获取当前用户的优惠券列表（优先读取缓存）
     *
     * @param memberId 会员id
     * @return 会员优惠券列表
     */
    @GetMapping("/feign/promotion/member/coupon/list/{memberId}")
    List<MemberCoupon> getMemberCoupons(@PathVariable String memberId);

    /**
     * 获取当前会员全品类优惠券
     *
     * @param memberId 会员Id
     * @param storeId  店铺id
     * @return 会员优惠券列表
     */
    @PostMapping("/feign/promotion/member/coupon/all/{memberId}")
    List<MemberCoupon> getAllScopeMemberCoupon(@PathVariable String memberId, @RequestBody List<String> storeId);

    /**
     * 获取会员优惠券
     *
     * @param param  查询参数
     * @return 会员优惠券列表
     */
    @PostMapping("/feign/promotion/member/coupon/one")
    MemberCoupon getMemberCoupon(@RequestBody MemberCouponSearchParams param);

    /**
     * 根据ID获取积分详情
     *
     * @param skuId 商品SkuId
     * @return 积分详情
     */
    @GetMapping("/feign/promotion/points/{skuId}")
    PointsGoodsVO getPointsGoodsDetailBySkuId(@PathVariable String skuId);

    @GetMapping("/feign/promotion/pintuan/{id}")
    PintuanVO getPintuanVO(@PathVariable String id);

    @PostMapping("/feign/promotion/kanjia")
    KanjiaActivityVO getKanjiaActivityVO(@RequestBody KanjiaActivitySearchParams kanjiaActivitySearchParams);

    @GetMapping("/feign/promotion/member/coupon/can-use")
    List<MemberCoupon> getCurrentGoodsCanUse(@RequestParam String memberId, @RequestParam List<String> couponIds, @RequestParam Double totalPrice);

    /**
     * 获取促销商品信息
     *
     * @param searchParams 查询参数
     * @return 促销商品列表
     */
    @PostMapping("/feign/promotion/goods/list")
    List<PromotionGoods> listFindAll(@RequestBody PromotionGoodsSearchParams searchParams);

    /**
     * 获取促销商品信息
     *
     * @param searchParams 查询参数
     * @return 促销商品信息
     */
    @PostMapping("/feign/promotion/goods/get")
    PromotionGoods getPromotionsGoods(@RequestBody PromotionGoodsSearchParams searchParams);

    /**
     * 根据商品索引获取当前商品索引的所有促销活动信息
     *
     * @param storeId 店铺id
     * @param goodsSkuId 商品skuId
     * @return 当前促销活动集合
     */
    @GetMapping("/feign/promotion/{goodsSkuId}/map")
    Map<String, Object> getGoodsSkuPromotionMap(@RequestParam String storeId,@PathVariable String goodsSkuId);

    /**
     * 使用优惠券
     *
     * @param couponId 优惠券id
     * @param usedNum  使用数量
     */
    @PutMapping("/feign/promotion/coupon/{couponId}/used")
    void usedCoupon(@PathVariable String couponId, @RequestParam Integer usedNum);

    /**
     * 删除商品，则删除相关促销信息
     *
     * @param goodsIdsJsonStr
     */
    @PutMapping("/feign/promotion/removeByGoodsIds")
    void removeByGoodsIds(@RequestParam String goodsIdsJsonStr);

    @PostMapping("/feign/promotion/findSkuValidPromotions")
    List<PromotionGoods> findSkuValidPromotions(@RequestBody List<GoodsSkuDTO> skus);

    /**
     * 根据促销商品信息包装促销信息
     *
     * @param promotionGoodsList 促销商品信息
     * @return 促销信息
     */
    @PostMapping("/feign/promotion/wrapperPromotionMapList")
    Map<String, Object> wrapperPromotionMapList(@RequestBody List<PromotionGoods> promotionGoodsList);

    @GetMapping("/feign/promotion/getCouponById")
    Coupon getCouponById(@RequestParam String id);

    /**
     * 根据商品分类删除促销商品活动
     * @param categoryId
     */
    @PutMapping("/feign/promotion/deletePromotions")
    void deletePromotions(@RequestParam String categoryId);
}
