package cn.lili.modules.promotion.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.promotion.entity.dos.Seckill;
import cn.lili.modules.promotion.entity.dto.SeckillCheckDTO;
import cn.lili.modules.promotion.entity.dto.search.SeckillSearchParams;
import cn.lili.modules.promotion.fallback.SeckillFallback;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author paulG
 * @since 2022/1/14
 **/
@FeignClient(name = ServiceConstant.PROMOTION_SERVICE, contextId = "seckill",fallback = SeckillFallback.class)
public interface SeckillClient {

    @PostMapping("/feign/promotion/seckill")
    boolean savePromotions(@RequestBody Seckill seckill);

    /**
     * 根据条件查询秒杀活动
     *
     * @param searchParams 查询参数
     * @return 秒杀活动列表
     */
    @PostMapping("/feign/promotion/seckill/list")
    List<Seckill> listFindAll(@RequestBody SeckillSearchParams searchParams);


    /**
     * 检测秒杀活动是否存在
     *
     * @return 秒杀活动列表
     */
    @PostMapping("/feign/promotion/seckill/check")
    List<Seckill> checkSeckillIsActive(@RequestBody SeckillCheckDTO seckillCheckDTO);

    /**
     * 添加秒杀活动
     * 从系统设置中获取秒杀活动的配置
     * 添加30天后的秒杀活动
     * @return
     */
    @PostMapping("/feign/promotion/seckill/addSeckill")
    boolean addSeckill();

    /**
     * 修改促销商品中店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/promotion/seckill/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
