package cn.lili.modules.promotion.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.promotion.client.CouponActivityClient;
import cn.lili.modules.promotion.entity.dos.CouponActivity;
import cn.lili.modules.promotion.entity.dos.MemberCoupon;
import cn.lili.modules.promotion.entity.dto.CouponActivityTrigger;
import cn.lili.modules.promotion.entity.vos.CouponActivityVO;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 18:14
 * @description: 优惠券活动Fallback
 */
@Component
public class CouponActivityFallback implements CouponActivityClient {
    @Override
    public CouponActivityVO getCouponActivityVO(String couponActivityId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<CouponActivity> list() {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<MemberCoupon> trigger(CouponActivityTrigger couponActivityTrigger) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreName(Store store) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
