package cn.lili.modules.promotion.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.promotion.client.KanjiaActivityClient;
import cn.lili.modules.promotion.entity.dos.KanjiaActivity;
import cn.lili.modules.promotion.entity.dto.search.KanjiaActivitySearchParams;
import org.springframework.stereotype.Component;

/**
 * @author: ftyy
 * @date: 2022-01-13 18:50
 * @description: 描述
 */
@Component
public class KanjiaActivityFallback implements KanjiaActivityClient {

    /**
     * 结束砍价活动
     *
     * @param kanjiaId 砍价活动id
     * @return 是否更新成功
     */
    @Override
    public boolean endKanjiaActivity(String kanjiaId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public KanjiaActivity getById(String promotionId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public KanjiaActivity getKanjiaActivity(KanjiaActivitySearchParams kanJiaActivitySearchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
