package cn.lili.modules.promotion.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.promotion.client.MemberCouponClient;
import cn.lili.modules.store.entity.dos.Store;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-13 17:45
 * @description: 会员优惠券Fallback
 */
@Component
public class MemberCouponFallback implements MemberCouponClient {


    @Override
    public void receiveCoupon(String couponId, String memberId, String memberName) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void used(String memberId, List<String> ids) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 作废无效的会员优惠券
     *
     * @return 是否操作成功
     */
    @Override
    public boolean expireInvalidMemberCoupon() {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 删除作废/过期的会员优惠券
     *
     * @param expirationDay 过期常量，过期后或者使用后一定时间内，删除无效的优惠券，物理删除
     * @return 是否操作成功
     */
    @Override
    public boolean removeInvalidMemberCoupon(int expirationDay) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public boolean recoveryMemberCoupon(List<String> memberCouponIds) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void cleanMemberCouponSign() {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public Long getMemberCouponCount(String memberId, String couponId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreName(Store store) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
