package cn.lili.modules.search.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.search.entity.dos.CustomWords;
import cn.lili.modules.search.entity.params.CustomWordsParams;
import cn.lili.modules.search.entity.vo.CustomWordsVO;
import cn.lili.modules.search.fallback.CustomWordsFallback;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2021-12-25 18:19
 * @description: 自定义分词 client
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "customWords", fallback = CustomWordsFallback.class)
public interface CustomWordsClient {

    /**
     * 自定义分词部署替换
     *
     * @return 替换的内容
     */
    @GetMapping("/feign/goods/customWords/deploy")
    String deploy();

    /**
     * 添加自定义分词
     *
     * @param customWordsVO 自定义分词信息
     * @return 是否添加成功
     */
    @PostMapping("/feign/goods/customWords/addCustomWords")
    boolean addCustomWords(@RequestBody CustomWordsVO customWordsVO);

    /**
     * 根据名字批量删除
     *
     * @param names 名称列表
     * @return 是否删除成功
     */
    @DeleteMapping("/feign/goods/customWords/deleteBathByName")
    boolean deleteBathByName(@RequestBody List<String> names);

    /**
     * 批量保存自定义分词
     *
     * @param customWordsList 自定义分词信息
     */
    @PostMapping("/feign/goods/customWords/addCustomWordsList")
    void addCustomWordsList(@RequestBody List<CustomWords> customWordsList);

    /**
     * 修改自定义分词
     *
     * @param customWordsVO 自定义分词信息
     * @return 是否修改成功
     */
    @PutMapping("/feign/goods/customWords/updateCustomWords")
    boolean updateCustomWords(@RequestBody CustomWordsVO customWordsVO);


    /**
     * 删除自定义分词
     *
     * @param id 自定义分词id
     * @return 是否删除成功
     */
    @GetMapping("/feign/goods/customWords/deleteCustomWords/{id}")
    boolean deleteCustomWords(@PathVariable String id);

    /**
     * 分页查询自定义分词
     *
     * @param customWordsParams
     * @return
     */
    @PostMapping("/feign/goods/customWords/getCustomWordsByPage")
    Page<CustomWords> getCustomWordsByPage(@RequestBody CustomWordsParams customWordsParams);

    /**
     * 批量插入自定义分词
     *
     * @param customWordsList 自定义分词列表
     * @return 受影响行数
     */
    @PostMapping("/feign/goods/customWords/insertBatchCustomWords")
    long insertBatchCustomWords(@RequestBody List<CustomWords> customWordsList);

}
