package cn.lili.modules.search.entity.dto;

import cn.lili.modules.promotion.entity.dos.PromotionGoods;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 商品搜索结果实体
 *
 * @author paulG
 * @since 2020/10/16
 **/
@Data
@NoArgsConstructor
public class EsGoodsIndexUpdatePromotionsDTO {

    private String id;
    private List<String> ids;
    private List<PromotionGoods> promotionGoodsList;
    /**
     * 促销信息
     */
    private String promotionsJsonStr;

    public EsGoodsIndexUpdatePromotionsDTO(String promotionsJsonStr, List<String> ids) {
        this.ids = ids;
        this.promotionsJsonStr = promotionsJsonStr;
    }

    public EsGoodsIndexUpdatePromotionsDTO(List<PromotionGoods> promotionGoodsList, String promotionsJsonStr) {
        this.promotionGoodsList = promotionGoodsList;
        this.promotionsJsonStr = promotionsJsonStr;
    }

    public EsGoodsIndexUpdatePromotionsDTO(String promotionsJsonStr) {
        this.promotionsJsonStr = promotionsJsonStr;
    }
}
