package cn.lili.modules.sms.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.sms.fallback.SmsFallback;
import cn.lili.modules.system.entity.params.SmsParams;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 短信Client
 *
 * @author paulG
 * @since 2022/1/13
 **/
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "sms", fallback = SmsFallback.class)
public interface SmsClient {

    /**
     * 验证码发送
     *
     * @param smsParams
     */
    @PostMapping("/feign/sms/send")
    void sendSmsCode(@RequestBody SmsParams smsParams);

    /**
     * 验证码验证
     *
     * @param smsParams
     * @return
     */
    @PostMapping("/feign/sms/verify")
    boolean verifyCode(@RequestBody SmsParams smsParams);

    /**
     * 短信批量发送
     *
     * @param smsParams
     */
    @PostMapping("/feign/sms/send/batch")
    void sendBatchSms(@RequestBody SmsParams smsParams);


}
