package cn.lili.modules.statistics.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.statistics.entity.dos.MemberStatisticsData;
import cn.lili.modules.statistics.fallback.MemberStatisticsDataFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author paulG
 * @since 2022/1/14
 **/
@FeignClient(
        name = ServiceConstant.STATISTICS_SERVICE,
        contextId = "member-statistics-data",
        fallback = MemberStatisticsDataFallback.class)
public interface MemberStatisticsDataClient {


    @PostMapping("/feign/member-statistics")
    boolean addMemberStatistics(@RequestBody MemberStatisticsData memberStatisticsData);

}
