package cn.lili.modules.store.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.store.entity.dos.StoreAddress;
import cn.lili.modules.store.entity.dos.StoreDetail;
import cn.lili.modules.store.entity.dos.TuiaStore;
import cn.lili.modules.store.entity.dto.StoreAfterSaleAddressDTO;
import cn.lili.modules.store.entity.dto.StoreDeliverGoodsAddressDTO;
import cn.lili.modules.store.entity.dto.StoreSettlementDay;
import cn.lili.modules.store.entity.params.StoreParams;
import cn.lili.modules.store.entity.vos.StoreDetailVO;
import cn.lili.modules.store.entity.vos.StoreSearchParams;
import cn.lili.modules.store.entity.vos.StoreVO;
import cn.lili.modules.store.fallback.StoreFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 店铺 client
 *
 * @author Chopper
 * @version v1.0 2021-11-08 09:52
 */
@FeignClient(
        name = ServiceConstant.MEMBER_SERVICE,
        contextId = "store",
        fallback = StoreFallback.class)
public interface StoreClient {

    /**
     * 获取店铺详情
     *
     * @param id 店铺id
     * @return 店铺详情
     */
    @GetMapping("/feign/store/query/getStoreDetailVO/{id}")
    StoreDetailVO getStoreDetailVO(@PathVariable("id") String id);

    @GetMapping("/feign/store/query/getStoreInfo/{id}")
    TuiaStore getStoreInfo(@PathVariable("id") String id);

    /**
     * 根据店铺ID获取店铺信息DO
     *
     * @param storeId 店铺ID
     * @return 店铺信息DO
     */
    @GetMapping("/feign/store/query/getStoreDetail")
    StoreDetail getStoreDetail(@RequestParam String storeId);


    /**
     * 获取售后卖家地址
     *
     * @param storeId 店铺id
     * @return 店铺收货地址
     */
    @GetMapping("/feign/store/after-sale/address")
    StoreAfterSaleAddressDTO getStoreAfterSaleAddressDTO(@RequestParam String storeId);

    /**
     * 获取待结算店铺列表
     *
     * @param day 结算日
     * @return 待结算店铺列表
     */
    @GetMapping("/feign/store/settlement/day")
    List<StoreSettlementDay> getSettlementStore(@RequestParam int day);

    /**
     * 获取当前登录店铺信息
     *
     * @return 店铺信息DO
     */
    @GetMapping("/feign/store/{storeId}/getStore")
    StoreVO getStore(@PathVariable String storeId);

    /**
     * 列表查询
     *
     * @param searchParams 查询参数
     * @return 店铺列表
     */
    @PostMapping("/feign/store/list")
    List<Store> list(@RequestBody StoreSearchParams searchParams);


    /**
     * 修改店铺的结算日
     *
     * @param storeParams
     */
    @PutMapping("/feign/store/settlement/day")
    void updateSettlementDay(@RequestBody StoreParams storeParams);

    /**
     * 更新评分
     *
     * @param storeParams
     * @return
     */
    @PutMapping("/feign/store/settlement/updateScore")
    boolean updateScore(@RequestBody StoreParams storeParams);

    @PutMapping("/feign/store/settlement/updateStoreGoodsNum/{storeId}")
    void updateStoreGoodsNum(@PathVariable String storeId, @RequestBody Long goodsNum);

    @GetMapping("/feign/store/{id}/getStoreAddress")
    StoreAddress getStoreAddress(@PathVariable String id);

    /**
     * 获取某一个店铺的发货寄件地址信息
     *
     * @param id 店铺ID
     * @return 店铺发件地址
     */
    @GetMapping("/feign/store/{id}/getStoreDeliverGoodsAddressDto")
    StoreDeliverGoodsAddressDTO getStoreDeliverGoodsAddressDto(@PathVariable String id);

    /**
     * 根据店铺ID获取服务商ID
     *
     * @param storeId 店铺ID
     * @return
     */
    @GetMapping("/feign/store/getStoreSubMchid")
    String getStoreSubMchid(@RequestParam String storeId);

    @PutMapping("/feign/store/updateStoreManager/{storeId}")
    void updateStoreManager(@PathVariable String storeId, @RequestParam String storeManager);

    @PostMapping("/feign/store/getStoreByStoreIds")
    List<TuiaStore> getStoreByStoreIds(@RequestBody List<String> storeIds);
}
