package cn.lili.modules.store.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.store.entity.dos.StoreLogistics;
import cn.lili.modules.store.fallback.StoreLogisticsFallback;
import cn.lili.modules.system.entity.vo.StoreLogisticsVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author: ftyy
 * @date: 2022-01-19 18:07
 * @description: 店铺-物流公司
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "storeLogistics", fallback = StoreLogisticsFallback.class)
public interface StoreLogisticsClient {

    /**
     * 获取当前店铺的物流公司列表
     *
     * @param id 店铺id
     * @return 物流公司列表
     */
    @GetMapping("/feign/member/storeLogistics/{id}")
    List<StoreLogisticsVO> getStoreLogistics(@PathVariable String id);


    /**
     * 获取当前店铺的物流公司列表
     *
     * @param storeId 店铺id
     * @return 物流公司列表
     */
    @GetMapping("/feign/member/storeLogistics/{logisticsId}/{storeId}")
    StoreLogistics getStoreLogistics(@PathVariable String logisticsId, @PathVariable String storeId);
    /**
     * 获取当前店铺已选择的物流公司列表
     *
     * @param storeId 店铺id
     * @return 物流公司列表
     */
    @GetMapping("/feign/member/storeLogistics/getStoreSelectedLogistics")
    List<StoreLogisticsVO> getStoreSelectedLogistics(@RequestParam String storeId);

    /**
     * 获取当前店铺已选择的物流公司名称列表
     *
     * @param storeId 店铺id
     * @return 物流公司列表
     */
    @GetMapping("/feign/member/storeLogistics/getStoreSelectedLogisticsName")
    List<String> getStoreSelectedLogisticsName(@RequestParam String storeId);

}
