package cn.lili.modules.store.entity.dto;

import cn.lili.common.vo.PageVO;
import cn.lili.modules.order.order.entity.enums.FlowTypeEnum;
import cn.lili.modules.statistics.entity.dto.StatisticsQueryParam;
import cn.lili.modules.statistics.util.StatisticsDateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author paulG
 * @since 2022/6/24
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class StoreStatisticsSearchParams extends PageVO {

    private static final long serialVersionUID = -6541148084626734649L;

    public StatisticsQueryParam statisticsQueryParam;

    public QueryWrapper storeStatisticsDataWrapper() {
        QueryWrapper queryWrapper = Wrappers.query();

        Date[] dates = StatisticsDateUtil.getDateArray(this.statisticsQueryParam);
        Date startTime = dates[0];
        Date endTime = dates[1];
        queryWrapper.between("create_time", startTime, endTime);

        queryWrapper.orderByDesc("price");

        queryWrapper.groupBy("store_id,store_name ");

        queryWrapper.eq("flow_type", FlowTypeEnum.PAY.name());

        return queryWrapper;
    }


}
