package cn.lili.modules.store.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.payment.client.BillClient;
import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.store.entity.params.BillParams;
import org.springframework.stereotype.Component;

/**
 * @author: ftyy
 * @date: 2022-01-13 14:53
 * @description: 结算单Fallback
 */
@Component
public class BillFallback implements BillClient {

    /**
     * 生成结算单
     * @param billParams
     */
    @Override
    public void createBill(BillParams billParams) {
        throw new ServiceException(ResultCode.ERROR);
    }


    /**
     * 立即结算
     * 用于关闭商家，立即结算使用
     * @param billParams
     */
    @Override
    public void immediatelyBill(BillParams billParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreName(Store store) {
        throw new ServiceException(ResultCode.ERROR);
    }

}
