package cn.lili.modules.store.fallback;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.store.client.StoreClient;
import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.store.entity.dos.StoreAddress;
import cn.lili.modules.store.entity.dos.StoreDetail;
import cn.lili.modules.store.entity.dos.TuiaStore;
import cn.lili.modules.store.entity.dto.StoreAfterSaleAddressDTO;
import cn.lili.modules.store.entity.dto.StoreDeliverGoodsAddressDTO;
import cn.lili.modules.store.entity.dto.StoreSettlementDay;
import cn.lili.modules.store.entity.params.StoreParams;
import cn.lili.modules.store.entity.vos.StoreDetailVO;
import cn.lili.modules.store.entity.vos.StoreSearchParams;
import cn.lili.modules.store.entity.vos.StoreVO;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * StoreServiceFallback
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-17 14:46
 */
@Component
public class StoreFallback implements StoreClient {


    @Override
    public StoreDetailVO getStoreDetailVO(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public TuiaStore getStoreInfo(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public StoreDetail getStoreDetail(String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public StoreAfterSaleAddressDTO getStoreAfterSaleAddressDTO(String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 获取待结算店铺列表
     *
     * @param day 结算日
     * @return 待结算店铺列表
     */
    @Override
    public List<StoreSettlementDay> getSettlementStore(int day) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public StoreVO getStore(String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    /**
     * 列表查询
     *
     * @param searchParams 查询参数
     * @return 店铺列表
     */
    @Override
    public List<Store> list(StoreSearchParams searchParams) {
        throw new ServiceException(ResultCode.ERROR);
    }


    /**
     * 修改店铺的结算日
     *
     * @param storeParams
     */
    @Override
    public void updateSettlementDay(StoreParams storeParams) {
        throw new ServiceException(ResultCode.ERROR);
    }


    /**
     * 更新评分
     *
     * @param storeParams
     * @return
     */
    @Override
    public boolean updateScore(StoreParams storeParams) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreGoodsNum(String storeId, Long num) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public StoreDeliverGoodsAddressDTO getStoreDeliverGoodsAddressDto(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public String getStoreSubMchid(String storeId) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public void updateStoreManager(String storeId, String storeManager) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public StoreAddress getStoreAddress(String id) {
        throw new ServiceException(ResultCode.ERROR);
    }

    @Override
    public List<TuiaStore> getStoreByStoreIds(List<String> storeIds) {
        throw new ServiceException(ResultCode.ERROR);
    }
}
