package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.system.entity.dos.Logistics;
import cn.lili.modules.system.entity.vo.Traces;
import cn.lili.modules.system.fallback.LogisticsFallback;
import com.kuaidi100.sdk.response.SubscribeWithMapPushParamResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 物流配置客户端
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "logistic", fallback = LogisticsFallback.class)
public interface LogisticsClient {


    /**
     * 根据id获取物流配置
     *
     * @return 全部物流
     */
    @GetMapping("/feign/logistics/all")
    List<Logistics> list();

    /**
     * 根据id获取物流配置
     *
     * @return
     */
    @GetMapping("/feign/logistics/query/{logisticsId}")
    Logistics getById(@PathVariable String logisticsId);


    @GetMapping("/feign/logistics/queryByLogisticsName")
    Logistics getByName(@RequestParam("logisticsName") String logisticsName);

    /**
     * 查看物流详情
     *
     * @return
     */
    @GetMapping("/feign/logistics/query/traces")
    Traces getLogistic(@RequestParam(required = false) String logisticsId,
                       @RequestParam(required = false) String logisticsNo,
                       @RequestParam(required = false) String phone);

    @GetMapping("/feign/logistics/subscribe/traces")
    Boolean subscribeLogistic(@RequestParam(required = false) String logisticsId,
                              @RequestParam(required = false) String logisticsNo,
                              @RequestParam(required = false) String callbackUrl,
                              @RequestParam(required = false) String phone);

    @PostMapping("/feign/logistics/subscribe/traces/push")
    Traces pushLogistic(@RequestBody SubscribeWithMapPushParamResp subscribe);


    @GetMapping("/feign/logistics/query/map/traces")
    Traces getLogisticMapTrack(@RequestParam String logisticsId, @RequestParam String logisticsNo, @RequestParam String phone, @RequestParam String from, @RequestParam String to);

    @GetMapping("/feign/logistics/labelOrder")
    Map labelOrder(@RequestParam String orderSn, @RequestParam String logisticsId);

}
