package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.message.entity.dos.MemberMessage;
import cn.lili.modules.system.fallback.MemberMessageFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 会员消息发送Client
 * @author paulG
 * @since 2022/1/13
 **/
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "member-message",fallback = MemberMessageFallback.class)
public interface MemberMessageClient {


    /**
     * 修改会员消息状态
     *
     * @param status    状态
     * @param messageId 消息id
     * @return 操作状态
     */
    @PutMapping("/feign/member-message/edit/status/{messageId}")
    Boolean editStatus(@RequestParam String status,@PathVariable String messageId);

    /**
     * 删除消息
     *
     * @param messageId 消息id
     * @return 操作状态
     */
    @DeleteMapping("/feign/member-message/delete/{messageId}")
    Boolean deleteMessage(@PathVariable String messageId);


    /**
     * 保存消息信息
     *
     * @param messages 消息
     * @return 操作状态
     */
    @PostMapping("/feign/member-message/save")
    boolean save(@RequestBody List<MemberMessage> messages);


}
