package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.system.entity.dto.MinAppDTO;
import cn.lili.modules.system.fallback.MinAppFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Author yuquanfeng
 * @Date 2023/11/2
 * @Description
 **/
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "minApp",fallback = MinAppFallback.class)
public interface MinAppClient {

    @GetMapping("/feign/min/app/queryValidMinApp")
    List<MinAppDTO> queryValidMinApp();


    @GetMapping("/feign/min/app/list")
    List<String> queryAllAppIds();

    @PostMapping("/feign/min/app/updateCount")
    Boolean updateCount(@RequestBody MinAppDTO minAppDTO);

    @GetMapping("/feign/min/app/queryByAppId")
    MinAppDTO queryByAppId(@RequestParam("appId") String appId);
}
