package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.system.entity.dos.Setting;
import cn.lili.modules.system.fallback.SettingFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 系统配置 client
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "setting",fallback = SettingFallback.class)
public interface SettingClient {

    /**
     * 获取系统配置
     *
     * @param key 配置关键字
     * @return 系统配置
     */
    @GetMapping("/feign/setting/query/{key}")
    Setting get(@PathVariable("key") String key);
}
