package cn.lili.modules.system.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.message.entity.dos.StoreMessage;
import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.system.fallback.StoreMessageFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 店铺接收消息Client
 * @author paulG
 * @since 2022/1/13
 **/
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "store-message",fallback = StoreMessageFallback.class)
public interface StoreMessageClient {

    /**
     * 通过消息id删除
     *
     * @param messageId 消息ID
     * @return 操作结果
     */
    @DeleteMapping("/feign/store-message/delete/{messageId}")
    boolean deleteByMessageId(@PathVariable String messageId);

    /**
     * 保存店铺消息信息
     *
     * @param messages 消息
     * @return 操作结果
     */
    @PostMapping("/feign/store-message/save")
    boolean save(@RequestBody List<StoreMessage> messages);


    /**
     * 修改店铺消息状态
     *
     * @param status 状态
     * @param id     id
     * @return 操作结果
     */
    @PutMapping("/feign/store-message/edit/status/{id}")
    boolean editStatus(@RequestParam String status, @PathVariable String id);

    /**
     * 修改店铺消息中的店铺名称
     *
     * @param store 店铺信息
     */
    @PutMapping("/feign/store-message/updateStoreName")
    void updateStoreName(@RequestBody Store store);
}
