package cn.lili.modules.system.entity.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author yuquanfeng
 * @Date 2023/11/2
 * @Description
 **/
@Data
public class MinAppDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /** 主键 */
    private Long id;
    /** 创建时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;
    /** 修改时间 */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date gmtModified;
    /** 小程序名称 */
    private String appName;
    /** 小程序原始id */
    private String appOriginalId;
    /** 小程序id */
    private String appId;
    /** 小程序密钥 */
    private String appSecret;
    /** 小程序状态 1-开启 0-暂停 */
    private Integer appStatus;
    /** api调用量 */
    private Long apiDailyCallAmount;
    /** 备注 */
    private String remark;
    /** 主体名称 */
    private String principalName;
    /** 小程序码 */
    private String appQrCode;
    /**
     * schema状态 0-可用 1-不可用
     */
    private Integer schemaStatus;

    private Integer currentPage;

    private Integer pageSize;

    private Integer rowStart;

    private Date startTime;

    private Date endTime;
}
