package cn.lili.modules.system.entity.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 积分签到设置
 *
 * @author Chopper
 * @since 2021-02-26 11:48
 */
@Data
public class PointSettingItem implements Comparable<PointSettingItem>, Serializable {


    private static final long serialVersionUID = 7839694686508043792L;

    @ApiModelProperty(value = "签到天数")
    private Integer day;


    @ApiModelProperty(value = "赠送积分")
    private Integer points;

    public Integer getPoint() {
        if (points == null || points < 0) {
            return 0;
        }
        return points;
    }

    public void setPoint(Integer point) {
        this.points = point;
    }

    @Override
    public int compareTo(PointSettingItem pointSettingItem) {
        return this.day - pointSettingItem.getDay();
    }
}
