package cn.lili.modules.util.client;

import cn.lili.common.vo.ResultMessage;
import cn.lili.modules.connect.entity.params.ConnectParams;
import cn.lili.modules.connect.request.AuthRequest;
import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.util.fallback.ConnectUtilFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.io.IOException;

/**
 * @author: ftyy
 * @date: 2022-01-17 18:07
 * @description: 联合登陆Client
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "connectUtil", fallback = ConnectUtilFallback.class)
public interface ConnectUtilClient {

    /**
     * 登录回调
     * @param connectParams
     * @throws IOException
     */
    @PostMapping("/feign/system/connect/util/callback")
    void callback(@RequestBody ConnectParams connectParams) throws IOException;

    /**
     * 获取响应结果
     *
     * @param state
     * @return
     */
    @GetMapping("/feign/system/connect/util/result/{state}")
    ResultMessage<Object> getResult(@PathVariable String state);

    /**
     * 联合登录
     *
     * @param type
     * @return
     */
    @GetMapping("/feign/system/connect/util/auth-request/{type}")
    AuthRequest getAuthRequest(@PathVariable String type);


}
