package cn.lili.modules.wechat.client;

import cn.hutool.json.JSONObject;
import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.goods.entity.dos.Commodity;
import cn.lili.modules.goods.entity.dos.Studio;
import cn.lili.modules.wechat.entity.params.WechatParams;
import cn.lili.modules.wechat.fallback.WechatFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 微信 client
 *
 * @author Chopper
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "wechat", fallback = WechatFallback.class)
public interface WechatClient {

    /**
     * 获取微信token
     *
     * @param clientTypeEnum 配置枚举
     * @return token
     */
    @GetMapping("/feign/wechat/token/{clientTypeEnum}")
    String cgiAccessToken(@PathVariable("clientTypeEnum") String clientTypeEnum);

    /**
     * 删除token
     *
     * @param clientTypeEnum 配置枚举
     */
    @DeleteMapping("/feign/wechat/token/{clientTypeEnum}")
    void removeAccessToken(@PathVariable("clientTypeEnum") String clientTypeEnum);

    @PostMapping("/feign/wechat/token/addGoods")
    JSONObject addGoods(@RequestBody Commodity commodity);

    @DeleteMapping("/feign/wechat/token/deleteGoods")
    JSONObject deleteGoods(@RequestParam String goodsId);

    @PostMapping("/feign/wechat/token/getGoodsWareHouse")
    JSONObject getGoodsWareHouse(@RequestBody List<String> goodsIdList);

    @DeleteMapping("/feign/wechat/token/goodsDeleteInRoom")
    Boolean goodsDeleteInRoom(@RequestBody WechatParams wechatParams);

    @PostMapping("/feign/wechat/token/create")
    Map<String, String> create(@RequestBody Studio studio);

    @PutMapping("/feign/wechat/token/editRoom")
    void editRoom(@RequestBody Studio studio);

    @PostMapping("/feign/wechat/token/getLiveInfo")
    String getLiveInfo(@RequestParam Integer roomId);

    @PostMapping("/feign/wechat/token/pushGoods")
    Boolean pushGoods(@RequestBody WechatParams wechatParams);
}
