package cn.lili.modules.wechat.client;

import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.wechat.fallback.WechatMpCodeFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = ServiceConstant.SYSTEM_SERVICE, contextId = "wechatMpCode", fallback = WechatMpCodeFallback.class)
public interface WechatMpCodeClient {


    /**
     * 小程序二维码生成：不限制数量，但是限制长度，只能存放32为长度
     * @param page
     * @param scene
     * @return
     */
    @GetMapping("/feign/wechatMpCode/createCode/{scene}")
    String createCode(@RequestParam String page,@PathVariable("scene") String scene);

    /**
     * 小程序二维码生成:只适用于少量场景，多数场景需要unlimited接口实现
     * @param page
     * @return
     */
    @GetMapping("/feign/wechatMpCode/createQrCode")
    String createQrCode(@RequestParam String page);
}
