package cn.lili.modules.wechat.client;

import cn.hutool.core.date.DateTime;
import cn.lili.modules.constant.ServiceConstant;
import cn.lili.modules.payment.entity.dos.StoreFlow;
import cn.lili.modules.wechat.entity.vos.FundBalanceVO;
import cn.lili.modules.wechat.fallback.WechatPayFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 微信进件 client
 *
 * @author Bulbasaur
 * @version v1.0
 * 2021-11-08 09:52
 */
@FeignClient(name = ServiceConstant.PAYMENT_SERVICE, contextId = "wechatPay", fallback = WechatPayFallback.class)
public interface WechatPayClient {

    /**
     * 查看进件状态
     */
    @GetMapping("/feign/wechat/applyments")
    void applyments();

    /**
     * 二级商户号账户实时余额
     *
     * @param subMchid 二级商户号
     */
    @GetMapping("/feign/wechat/subNowBalance")
    FundBalanceVO subNowBalance(String subMchid);

    /**
     * 二级商户分账
     */
    @PostMapping("/feign/wechat/profitSharing")
    void profitSharing(@RequestBody StoreFlow storeFlow);

    /**
     * 所有商户进行提现
     */
    @PostMapping("/feign/wechat/subWithdrawAll")
    void subWithdrawAll();
    /**
     * 查询分账结果
     */
    @GetMapping("/feign/wechat/queryProfitSharing")
    void queryProfitSharing();

    /**
     * 查询提现状态
     */
    @GetMapping("/feign/wechat/querySubWithdraw")
    void querySubWithdraw();

    /**
     * 申请交易账单
     */
    @PostMapping("/feign/wechat/tradeBill")
    void tradeBill(@RequestBody DateTime dateTime);

    /**
     * 申请资金账单
     */
    @PostMapping("/feign/wechat/fundFlowBill")
    void fundFlowBill(@RequestBody DateTime dateTime);

    /**
     * 申请分账账单
     */
    @PostMapping("/feign/wechat/bills")
    void bills(@RequestBody DateTime dateTime);


}
