package cn.lili.modules.wechat.entity.dto.applyments;

import cn.lili.modules.payment.entity.dos.WechatApplyment;
import cn.lili.modules.wechat.entity.SpecEncrypt;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 电商收付通
 * 二级商户进件申请
 *
 * @author Bulbasaur
 * https://pay.weixin.qq.com/wiki/doc/apiv3_partner/apis/chapter7_1_1.shtml
 */
@Data
@NoArgsConstructor
public class EcommerceDTO {

    /**
     * 1、服务商自定义的商户唯一编号。
     * 2、每个编号对应一个申请单，每个申请单审核通过后会生成一个微信支付商户号。
     * 3、若申请单被驳回，可填写相同的“业务申请编号”，即可覆盖修改原申请单信息 。
     */
    @ApiModelProperty(value = "业务申请编号")
    String out_request_no;
    /**
     * 非小微的主体类型需与营业执照/登记证书上一致，可参考选择主体指引，枚举值如下。
     * 2401：小微商户，指无营业执照的个人商家。
     * 2500：个人卖家，指无营业执照，已持续从事电子商务经营活动满6个月，且期间经营收入累计超过20万元的个人商家。（若选择该主体，请在“补充说明”填写相关描述）。
     * 4：个体工商户，营业执照上的主体类型一般为个体户、个体工商户、个体经营。
     * 2：企业，营业执照上的主体类型一般为有限公司、有限责任公司。
     * 3：事业单位，包括国内各类事业单位，如：医疗、教育、学校等单位。
     * 2502：政府机关，包括各级、各类政府机关，如机关党委、税务、民政、人社、工商、商务、市监等。
     * 1708：社会组织，包括社会团体、民办非企业、基金会、基层群众性自治组织、农村集体经济组织等组织。
     */
    @ApiModelProperty(value = "主体类型")
    String organization_type;
    /**
     * 选填，请根据申请主体的实际情况填写，可参考选择金融机构指引：
     * 1、若商户主体是金融机构，则填写：true。
     * 2、若商户主体不是金融机构，则填写：false。
     * 若未传入将默认填写：false。
     */
    @ApiModelProperty(value = "是否金融机构")
    Boolean finance_institution;
    /**
     * 1、主体为“小微/个人卖家”时，不填。
     * 2、主体为“个体工商户/企业”时，请上传营业执照。
     * 3、主体为“政府机关/事业单位/社会组织”时，请上传登记证书。
     */
    @ApiModelProperty(value = "营业执照/登记证书信息")
    BusinessLicenseInfo business_license_info;
    /**
     * 当主体是金融机构时，必填
     */
    @ApiModelProperty(value = "金融机构许可证信息")
    FinanceInstitutionInfo finance_institution_info;
    /**
     * 1. 主体类型为政府机关/事业单位时选传：
     * （1）若上传的是法人证件，则不需要上传该字段。
     * （2）若因特殊情况，无法提供法人证件时，可上传经办人。 （经办人：经商户授权办理微信支付业务的人员，授权范围包括但不限于签约，入驻过程需完成账户验证）。
     * 2. 主体类型为企业/个体户/社会组织时，默认为经营者/法人，不需要上传该字段。
     * LEGAL：法人
     * SUPER：经办人
     */
    @ApiModelProperty(value = "证件持有人类型")
    String id_holder_type;
    /**
     * 1、当证件持有人类型为经营者/法人时，需要填写。其他情况，无需上传。
     * 2、主体为“小微/个人卖家”，可选择：身份证。
     * 3、主体为“个体户/企业/事业单位/社会组织”：可选择任一证件类型，主体为“政府机关”仅支持中国大陆居民-身份证类型。
     * 4、若没有填写，系统默认选择：身份证。
     * 枚举值：
     * IDENTIFICATION_TYPE_MAINLAND_IDCARD：中国大陆居民-身份证
     * IDENTIFICATION_TYPE_OVERSEA_PASSPORT：其他国家或地区居民-护照
     * IDENTIFICATION_TYPE_HONGKONG：中国香港居民--来往内地通行证
     * IDENTIFICATION_TYPE_MACAO：中国澳门居民--来往内地通行证
     * IDENTIFICATION_TYPE_TAIWAN：中国台湾居民--来往大陆通行证
     * IDENTIFICATION_TYPE_FOREIGN_RESIDENT：外国人居留证
     * IDENTIFICATION_TYPE_HONGKONG_MACAO_RESIDENT：港澳居民证
     * IDENTIFICATION_TYPE_TAIWAN_RESIDENT：台湾居民证
     */
    @ApiModelProperty(value = "经营者/法人证件类型")
    String id_doc_type;
    /**
     * 1、当证件持有人类型为经办人时，必须上传。其他情况，无需上传。
     * 2、若因特殊情况，无法提供法定代表人证件时，请参照示例图打印法定代表人说明函，全部信息需打印，不支持手写商户信息，并加盖公章。
     * 3、可上传1张图片，请填写通过图片上传API预先上传图片生成好的MediaID。
     */
    @ApiModelProperty(value = "法定代表人说明函")
    String authorize_letter_copy;
    /**
     * 当证件持有人类型为经营者/法人且证件类型为“身份证”时填写。
     */
    @ApiModelProperty(value = "经营者/法人身份证信息")
    @SpecEncrypt
    IdCardInfo id_card_info;
    /**
     * 当证件持有人类型为经营者/法人且证件类型不为“身份证”时填写。
     */
    @ApiModelProperty(value = "经营者/法人其他类型证件信息")
    @SpecEncrypt
    IdDocInfo id_doc_info;
    /**
     * 主体类型为企业时，需要填写：
     * 1、若经营者/法人是最终受益人，则填写：true。
     * 2、若经营者/法人不是最终受益人，则填写：false。
     */
    @ApiModelProperty(value = "经营者/法人是否为受益人")
    Boolean owner;
    /**
     * 仅企业需要填写。
     * 若经营者/法人不是最终受益所有人，则需提填写受益所有人信息，最多上传4个。
     * 若经营者/法人是最终受益所有人之一，可在此填写其他受益所有人信息，最多上传3个。
     * 根据国家相关法律法规，需要提供公司受益所有人信息，受益所有人需符合至少以下条件之一：
     * 1、直接或者间接拥有超过25%公司股权或者表决权的自然人。
     * 2、通过人事、财务等其他方式对公司进行控制的自然人。
     * 3、公司的高级管理人员，包括公司的经理、副经理、财务负责人、上市公司董事会秘书和公司章程规定的其他人员。
     */
    @ApiModelProperty(value = "最终受益人信息列表")
    @SpecEncrypt
    List<UboInfo> ubo_info_list;

    /**
     * 请填写商家提现收款的银行账户信息
     */
    @ApiModelProperty(value = "结算账户信息")
    @SpecEncrypt
    AccountInfo account_info;
    /**
     * 请填写店铺的超级管理员信息。
     * 超级管理员需在开户后进行签约，并可接收日常重要管理信息和进行资金操作，请确定其为商户法定代表人或负责人。
     */
    @ApiModelProperty(value = "超级管理员信息")
    @SpecEncrypt
    ContactInfo contact_info;

    /**
     * 请填写店铺信息
     */
    @ApiModelProperty(value = "店铺信息")
    SalesSceneInfo sales_scene_info;

    /**
     * 请填写商家的结算费率规则、所属行业等信息。若电商平台未传入，系统将填写默认值
     */
    @ApiModelProperty(value = "结算规则")
    SettlementInfo settlement_info;

    /**
     * UTF-8格式，中文占3个字节，即最多21个汉字长度。将在支付完成页向买家展示，需与商家的实际售卖商品相符 。
     */
    @ApiModelProperty(value = "商户简称")
    String merchant_shortname;

    /**
     * 1、根据商户经营业务要求提供相关资质，详情查看《行业对应特殊资质》。
     * 2、请提供为“申请商家主体”所属的特殊资质，可授权使用总公司/分公司的特殊资 质；
     * 3、最多可上传5张照片，请填写通过图片上传接口预先上传图片生成好的MediaID 。
     */
    @ApiModelProperty(value = "特殊资质")
    String qualifications;

    /**
     * 根据实际审核情况，额外要求提供。最多可上传5张照片，请填写通过图片上传接口预先上传图片生成好的MediaID 。
     */
    @ApiModelProperty(value = "补充材料")
    String business_addition_pics;
    @ApiModelProperty(value = "补充说明")
    String business_addition_desc;

    public EcommerceDTO(WechatApplyment wechatApplyment) {
        this.out_request_no = wechatApplyment.getOutRequestNo();
        this.organization_type = wechatApplyment.getOrganizationType();
        this.finance_institution = wechatApplyment.getFinanceInstitution();
        this.business_license_info = JSON.parseObject(wechatApplyment.getBusinessLicenseInfo(), BusinessLicenseInfo.class);
        this.finance_institution_info = JSON.parseObject(wechatApplyment.getFinanceInstitutionInfo(), FinanceInstitutionInfo.class);
        this.id_holder_type = wechatApplyment.getIdHolderType();
        this.id_doc_type = wechatApplyment.getIdDocType();
        this.authorize_letter_copy = wechatApplyment.getAuthorizeLetterCopy();
        this.id_card_info = JSON.parseObject(wechatApplyment.getIdCardInfo(), IdCardInfo.class);
        this.id_doc_info = JSON.parseObject(wechatApplyment.getIdDocInfo(), IdDocInfo.class);
        this.owner = wechatApplyment.getOwner();
        this.account_info = JSON.parseObject(wechatApplyment.getAccountInfo(), AccountInfo.class);
        this.ubo_info_list = JSON.parseObject(wechatApplyment.getUboInfoList(), List.class);
        this.contact_info = JSON.parseObject(wechatApplyment.getContactInfo(), ContactInfo.class);
        this.sales_scene_info = JSON.parseObject(wechatApplyment.getSalesSceneInfo(), SalesSceneInfo.class);
        this.settlement_info = JSON.parseObject(wechatApplyment.getSettlementInfo(), SettlementInfo.class);
        this.merchant_shortname = wechatApplyment.getMerchantShortname();
        this.qualifications = wechatApplyment.getQualifications();
        this.business_addition_pics = wechatApplyment.getBusinessAdditionPics();
        this.business_addition_desc = wechatApplyment.getBusinessAdditionDesc();
    }
}
