package cn.lili.modules.wechat.entity.dto.applyments;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 店铺信息
 *
 * @author Bulbasaur
 */
@Data
public class SalesSceneInfo {

    /**
     * 请填写店铺全称。
     */
    @ApiModelProperty(value = "店铺名称")
    String store_name;

    /**
     * 1、店铺二维码or店铺链接二选一必填。
     * 2、请填写店铺主页链接，需符合网站规范。
     */
    @ApiModelProperty(value = "店铺链接")
    String store_url;

    /**
     * 1、店铺二维码 or 店铺链接二选一必填。
     * 2、若为电商小程序，可上传店铺页面的小程序二维码。
     * 3、请填写通过图片上传API预先上传图片生成好的MediaID，仅能上传1张图片 。
     */
    @ApiModelProperty(value = "店铺二维码")
    String store_qr_code;

    /**
     * 1、商户自定义字段，可填写已认证的小程序AppID，认证主体需与二级商户主体一致；
     * 2、完成入驻后， 系统发起二级商户号与该AppID的绑定（即配置为sub_appid，可在发起支付时传入）
     */
    @ApiModelProperty(value = "小程序AppID")
    String mini_program_sub_appid;


}
