package cn.lili.modules.wechat.entity.dto.applyments;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 结算规则
 * 请填写商家的结算费率规则、特殊资质等信息
 *
 * @author Bulbasaur
 */
@Data
@ApiModel(value = "结算规则")
public class SettlementInfo {

    /**
     * 入驻结算规则ID
     * 请选择结算规则ID，详细参见费率结算规则对照表
     * 示例值：719
     */
    @ApiModelProperty(value = "入驻结算规则ID")
    Integer settlement_id;

    /**
     * 所属行业
     * 填写指定行业名称，详细参见费率结算规则对照表
     * 示例值：餐饮
     */
    @ApiModelProperty(value = "所属行业")
    String qualification_type;

}
