/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.header;

import cn.hutool.core.util.ObjectUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignRequestInterceptor
implements RequestInterceptor {
    public void apply(RequestTemplate template) {
        Map<String, String> headers = this.getHeaders();
        headers.forEach((x$0, xva$1) -> template.header(x$0, new String[]{xva$1}));
    }

    private Map<String, String> getHeaders() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (ObjectUtil.isNull((Object)requestAttributes)) {
            return map;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            if (key.equalsIgnoreCase("content-length")) continue;
            map.put(key, value);
        }
        return map;
    }
}

